 ; Ŀ
 ;   Stand - insert a standard detail balloon.                             
 ;   Copyright 2000, 2001, 2003, 2010 by Rocket Software Ltd.              
 ;   When did you last oil your monitor?                                   
 ; 

 ; Ŀ
 ;   Subroutine Leda - draw a leader.                                      
 ;   Arguments: aa, the leader start point.                                
 ;   Returns the direction and endpoint of the last segment.               
 ; 
 (DEFUN LEDA (aa / disc bb cc ang)
  (setq disc (getvar "dimscale"))
  (setq bb (getpoint aa "Next point:\n"))
  (command "leader" aa bb)
  (grdraw aa bb -1)
  (setq palist (list aa bb))
  (while (setq cc (getpoint bb "Next point:\n"))
         (if (= (distance bb cc) 0) (write-line "Try moving the cursor\n")
             (progn
                   (command cc)
                   (grdraw cc bb -1)
                   (setq palist (append palist (list cc)))
                   (setq ang (angle bb cc))
                   (if cc (setq bb cc)))))
  (if (null cc)
      (progn
           (setq cc bb)
           (if (null ang) (setq ang (angle aa bb)))))
  (if (or (> ang (* 1.5 pi)) (< ang (/ pi 2)))
      (progn
          (if (/= ang 0)
              (command (setq aa (polar cc 0 (* disc 3))))
              (setq aa cc))
          (command "" "" "None")
          (grok palist)
          (list 0 aa))
      (progn
          (if (/= ang pi)
              (command (setq aa (polar cc pi (* disc 3))))
              (setq aa cc))
          (command "" "" "None")
          (grok palist)
          (list pi aa))))
 ; Ŀ
 ;   Leda end.                                                             
 ; 

 ; Ŀ
 ;   Grok - grdraw over a set of grlines.                                  
 ;   Takes one argument, a list of points.  Returns the empties.           
 ; 
 (DEFUN GROK (palist / sub1 sub2)
  (while (setq sub1 (car palist))
         (setq palist (cdr palist))
         (if (and sub1 sub2) (grdraw sub1 sub2 -1))
         (setq sub2 sub1))
 (princ))
 ; Ŀ
 ;   Grok end.                                                             
 ; 

 ; Ŀ
 ;   Stand.                                                                
 ; 
 (DEFUN C:STAND ( / esav disc pa palist pc dirr osmo)
  (setvar "cmdecho" 0)
  (command "undo" "m")
  (setq osmo (getvar "osmode"))
  (setvar "osmode" 0)
 ; Ŀ
 ;   Redefine error handler.                                               
 ; 
  (DEFUN *ERROR* (shk)
   (if osmo (setvar "osmode" osmo))
   (if palist (grok palist))
  (princ))
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
  (setq disc (misps))
 ; Ŀ
 ;   If the misc layer exists make it current, otherwise make it.          
 ; 
  (malaya "misc")
 ; Ŀ
 ;   Call Leda to draw the leader and return an end point and direction.   
 ; 
  (if (setq pa (getpoint "\nLeader start point or <Return> for none: "))
      (progn
           (setvar "orthomode" 0)
           (setq pc (leda pa))
           (command "change" (entlast) "" "p" "color" "red" "")
           (setq dirr (car pc))
           (setq pc (cadr pc))
           (setq pc (polar pc dirr (* 6 disc)))
           (command ".insert" "dettag" pc disc "" "0"))
      (progn
           (setq pb (getpoint "\nTag location: "))
           (command ".insert" "dettag" pb disc "" "0")))
  (setvar "osmode" osmo)
 (princ))